﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucCPASelection.ascx.cs" Inherits="ucCPASelection" %>
<ext:Window ID="wndSelectCPA" Title="Please select the clinical program area(s) you work in." 
    Hidden="true"
     Layout="AnchorLayout" Height="515" Width="855" 
      IDMode="Static" runat="server" Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
<Items>
      <ext:GridPanel
        ID="gpCPA"
        runat="server"
        AnchorHorizontal="99%" 
        MinHeight="160"
        Height="505"
        Padding="3" 
        Title="Please Select Your Default Clinical Program Area"
        >
        <Listeners>
        </Listeners>
        <SelectionModel>
            <ext:CheckboxSelectionModel ID="smCPA" runat="server" Mode="Single" >
                <Listeners>
                    <Select Handler="App.direct.UCCPASEL.OnCPASel(Ext.encode(record.data));" />
                    <Deselect Handler="App.direct.UCCPASEL.OnCPADeSel(Ext.encode(record.data));" />
                </Listeners>
            </ext:CheckboxSelectionModel>
        </SelectionModel>
        <ColumnModel runat="server">
            <Columns>
                <ext:Column runat="server"
                    DataIndex="CPA_TITLE" Text="Clinical Program Area"
                    Flex="95" />
            </Columns>
        </ColumnModel>
        <Store>
            <ext:Store
                ID="storCPA"
                AutoLoad="true"
                runat="server">
                <Model>
                    <ext:Model runat="Server" IDProperty="CPA_ID">
                        <Fields>
                            <ext:ModelField Name="CPA_ID" />
                            <ext:ModelField Name="CPA_TITLE" />
                            <ext:ModelField Name="CPA_DESCR" />
                        </Fields>
                    </ext:Model>
                </Model>
                <Reader>
                    <ext:JsonReader RootProperty="Tables[0].Rows">
                    </ext:JsonReader>
                </Reader>
            </ext:Store>
        </Store>
    </ext:GridPanel>
</Items>
</ext:Window>
